package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2022-09-08 11:51:42
 * @description: 中台导购分享业绩-导出明细列表查询请求对象
 */
@ApiModel(value = "中台导购分享业绩-导出明细列表查询请求对象")
@Getter
@Setter
@Builder
public class MallShareStaffOrderExportListRequestVO {

    @NotNull(message = "企业ID不能为空")
    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = true, example = "1L")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID不能为空")
    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = true, example = "1L")
    private Long sysBrandId;

    @NotBlank(message = "查询开始时间不能为空")
    @ApiModelProperty(name = "startDate", value = "查询开始时间", required = true, example = "")
    private String startDate;

    @NotBlank(message = "查询结束时间不能为空")
    @ApiModelProperty(name = "endDate", value = "查询结束时间", required = true, example = "")
    private String endDate;

    @ApiModelProperty(name = "storeCodeList", value = "店铺线上Code列表", example = "")
    private List<String> storeCodeList;

}
