package com.bizvane.members.facade.service.inner;

import com.bizvane.members.facade.exception.MemberException;
import com.bizvane.members.facade.vo.PageVo;
import com.bizvane.members.facade.vo.StatisticsMemberConsumeVo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.Map;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/17.
 */
public interface MemberConsumeRecordService {
    /**
     * 查询会员订单详情
     * @param pageVo
     * @param map
     * @return
     * @throws MemberException
     */
    public ResponseData findMemberConsumeRecordByMemberCode(PageVo pageVo,Map map)throws MemberException;


    /**
     * 统计会员消费数据
     *
     * @param sysCompanyId
     * @param sysBrandId
     * @param memberCode
     * @return
     */
    ResponseData<StatisticsMemberConsumeVo> statisticsMemberConsumeByMemberCode(Long sysCompanyId, Long sysBrandId, String memberCode);

    /**
     * 查询会员订单详情导出
     *
     * @param map
     * @param currentUser
     * @return
     */
    ResponseData<String> findMemberConsumeRecordByMemberCodeExport(Map map, SysAccountPO currentUser);
}
