package com.bizvane.members.facade.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

//会员 member 专属会员 非会员
public enum MemberPropertyEnum {
	/**
	 * 商秀查询会员类型 会员
	 */
	MEMBER("1", "会员"),
	/**
	 * 商秀查询会员类型 服务会员(专属会员)
	 */
	SERVICEMEMBER("2", "服务会员(专属会员)"),
	/**
	 * 商秀查询会员类型 非会员
	 */
	NOTMEMBER("3", "非会员"),
	/**
	 * 商秀查询会员类型 会员-专属会员
	 */
	MEMBER_SERVICEMEMBER("4", "会员-专属会员"),
	/**
	 * 商秀查询会员类型 会员-非会员
	 */
	MEMBER_NOTMEMBER("5", "会员-非会员"),
	/**
	 * 商秀查询会员类型 专属会员-非会员
	 */
	SERVICEMEMBER_NOTMEMBER("6", "专属会员-非会员"),
	/**
	 * 商秀查询会员类型 会员-专属会员-非会员
	 */
	MEMBER_SERVICEMEMBER_NOTMEMBER("7", "会员-专属会员-非会员");

	private String code;

	private String msg;

	public String getCode() {
		return code;
	}

	public String getMsg() {
		return msg;
	}

	MemberPropertyEnum(String code, String msg) {
		this.code = code;
		this.msg = msg;
	}

	/**
	 * 根据枚举code获得枚举msg
	 *
	 * @param code
	 * @return
	 */
	public static String getMemberTypeMessage(String code) {
		for (MemberPropertyEnum type : MemberPropertyEnum.values()) {
			if (type.getCode().equals(code)) {
				return type.getMsg();
			}
		}
		return "";
	}

	/**
	 * 根据枚举code获得枚举
	 *
	 * @param code
	 * @return
	 */
	public static MemberPropertyEnum getMemberPropertyTypeEnum(String code) {
		for (MemberPropertyEnum type : MemberPropertyEnum.values()) {
			if (type.getCode().equals(code)) {
				return type;
			}
		}
		return null;
	}

	/**
	 * 将该枚举全部转化成json
	 *
	 * @return
	 */
	public static JSONArray toJson() {
		JSONArray jsonArray = new JSONArray();
		for (MemberPropertyEnum e : MemberPropertyEnum.values()) {
			JSONObject object = new JSONObject();
			object.put("typeId", e.getCode());
			object.put("typeName", e.getMsg());
			jsonArray.add(object);
		}
		return jsonArray;
	}
}
