package com.bizvane.members.facade.service.api361;

import com.bizvane.centerstageservice.models.po.SysBrandPo;

import java.util.Arrays;
import java.util.List;

/**
 * 361品牌数据补偿另外两个品牌
 * @author dingShiChen
 * @since 2019/10/25
 */
public interface Brand361CommonService {

	/**
	 * 需要同步的三个品牌
	 */
	List<String> BRAND_LIST_361 = Arrays.asList("361DZ", "361ET", "361CQ");

	/**
	 * 根据当前sysBrandId，获取其他两个需要同步的品牌
	 * @param sysCompanyId
	 * @param sysBrandId
	 * @return
	 */
	List<SysBrandPo> getOtherBrands(Long sysCompanyId, Long sysBrandId);

	/**
	 * 根据线下门店code，获取线上门店code
	 * @param sysCompanyId
	 * @param sysBrandId
	 * @param offlineCode
	 * @return
	 */
	String getOnlineStoreCodeByOfflineCode(Long sysCompanyId, Long sysBrandId, String offlineCode);

	/**
	 * icrm门店code转换成sap门店code
	 * @param brandId
	 * @param storeCode
	 * @return
	 */
	String icrmStoreCodeTransformSapStoreCode(Long brandId, String storeCode);
}
