package com.bizvane.members.facade.enums;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/7/10.
 * 扩展属性类型枚举
 */
public enum ExtendPropTypeEnum {
    /**
     * 单选
     */
    REDIO_TYPE("1", "单选"),
    /**
     *多选
     */
    CHECKBOX_TYPE("2", "多选"),
    /**
     * 时间
     */
    TIME_TYPE("3", "时间"),
    /**
     * 数字
     */
    NUMBER_TYPE("4", "数字"),
    /**
     * 文本
     */
    TEXT_TYPE("5", "文本"),
    /**
     * 关联属性
     */
	RELATION_TYPE("6","关联属性");
	
	
    private String code;
    
    private String msg;

    ExtendPropTypeEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    //获取属性类型
    public static String getPropertyType(String code) {
        for (ExtendPropTypeEnum type : ExtendPropTypeEnum.values()) {
            if (code.equals(type.getCode())) {
                return type.getMsg();
            }
        }
        return "";
    }
}
