package com.bizvane.members.facade.enums;

import lombok.Getter;

/**
 * 抖音订单状态枚举
 */
@Getter
public enum TiktokOrderStatusEnum {
    
    INIT(0L, "初始化"),
    WAIT_PAY(100L, "待支付"),
    CANCEL(101L, "订单关闭"),
    PAY_SUCCESS(200L, "支付成功"),
    AVAILABLE(201L, "待使用"),
    FINISH(1L, "交易成功"),
    PART_PAY(150L, "部分支付");

    private final Long code;
    private final String desc;

    TiktokOrderStatusEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TiktokOrderStatusEnum getByCode(Long code) {
        if (code == null) {
            return null;
        }
        for (TiktokOrderStatusEnum status : values()) {
            if (status.getCode().equals(code)) {
                return status;
            }
        }
        return null;
    }

    public static boolean isValid(Long code) {
        return getByCode(code) != null;
    }
}