package com.bizvane.members.facade.vo;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderDetailRspVo {

    /**
     * 品牌编码
     */
    private String brandCode;

    /**
     * 订单明细单号
     */
    private String orderDetailNo;

    /**
     * 商品编号
     */
    private String productNo;

    /**
     * SKU 编码
     */
    private String sukCode;

    /**
     * 商品名称
     */
    private String productName;

    /**
     * 规格（商品样式）
     */
    private String specification;

    /**
     * 颜色
     */
    private String color;

    /**
     * 尺寸
     */
    private String size;

    /**
     * 数量
     */
    private Integer quantity;

    /**
     * 吊牌价
     */
    private BigDecimal tagPrice;

    /**
     * 成交价
     */
    private BigDecimal tradeAmountDetail;

    /**
     * 活动价
     */
    private BigDecimal activityPrice;

    /**
     * 折后价
     */
    private BigDecimal discountPrice;

    /**
     * 折扣（例如：0.9 表示 9 折）
     */
    private BigDecimal rebate;

    /**
     * 商品导购 code
     */
    private String productGuideCode;

    /**
     * 平均价格（字符串类型，可能用于特殊格式展示）
     */
    private String avgPrice;
}
