package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 参数名称
 * 品牌ID
 * 运营组织code
 * 会员卡号
 * 会员手机号
 * ERPID
 * 性别
 * 积分余额
 * 会员等级
 * 会员生日
 * 所属导购code
 * 所属店铺code
 * 所属群组
 * 所属code
 * 所属店铺城市
 * 所属店铺区域
 * 会员标签
 * 开卡日期
 * 开卡店铺code
 * 开卡渠道
 * 绑卡渠道
 */
@Data
public class MemberQueryResponse361Vo {

    @ApiModelProperty(value = "会员id", name = "mbrMemberId")
    private Long mbrMemberId;
    @ApiModelProperty(value = "会员code", name = "memberCode")
    private String memberCode;

    @ApiModelProperty(value = "品牌id", name = "brandId")
    private Long brandId;

    @ApiModelProperty(value = "运营组织code", name = "onlineOrgCode")
    private String onlineOrgCode;

    @ApiModelProperty(value = "会员线上卡号", name = "cardNo")
    private String cardNo;

    @ApiModelProperty(value = "会员手机号", name = "phone")
    private String phone;

    @ApiModelProperty(value = "erpId", name = "erpId")
    private String erpId;

    @ApiModelProperty(value = "会员性别", name = "gender")
    private String gender;

    @ApiModelProperty(value = "累计可用积分", name = "countIntegral")
    private Integer countIntegral;

    @ApiModelProperty(value = "会员等级Id", name = "levelId")
    private Long levelId;
    @ApiModelProperty(value = "会员等级code", name = "levelCode")
    private String levelCode;
    @ApiModelProperty(value = "会员等级名称", name = "levelName")
    private String levelName;


    @ApiModelProperty(value = "会员生日", name = "birthday")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "Asia/Shanghai")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date birthday;

    @ApiModelProperty(value = "服务导购id", name = "serviceGuideId")
    private Long serviceGuideId;
    @ApiModelProperty(value = "服务导购name", name = "serviceGuideName")
    private String serviceGuideName;
    @ApiModelProperty(value = "服务导购线下code", name = "serviceGuideCode", required = false, example = "服务导购线下code")
    private String serviceGuideCode;

    @ApiModelProperty(value = "服务门店id", name = "serviceStoreId")
    private Long serviceStoreId;
    @ApiModelProperty(value = "服务门店线下code", name = "serviceStoreCode", required = false, example = "服务门店线下code")
    private String serviceStoreCode;
    @ApiModelProperty(value = "服务门店线下名字")
    private String serviceStoreName;

    private String serviceStoreProvince;
    private String serviceStoreCity;
    private String serviceStoreArea;
    //所属群组、code、id
    private String storeGroupIds;
    private String storeGroupCodes;
    private String storeGroupNames;


    @ApiModelProperty(value = "会员标签Ids", name = "labelIds")
    private String labelIds;
    @ApiModelProperty(value = "会员标签names", name = "labelNames")
    private String labelNames;


    @ApiModelProperty(value = "开卡时间", name = "openCardTime")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date openCardTime;


    @ApiModelProperty(value = "开卡店铺id")
    private Long openCardStoreId;
    @ApiModelProperty(value = "开卡店铺线下code", name = "openCardStoreCode", example = "开卡店铺线下code")
    private String openCardStoreCode;
    @ApiModelProperty(value = "开卡店铺线名称(个别场景有值)", name = "openCardStoreName")
    private String openCardStoreName;


    @ApiModelProperty(value = "开卡渠道id", name = "openCardChannelId")
    private Long openCardChannelId;
    private String openCardChannelName;
    private List<ChannelVo> bindCardChannelList;

    @Data
    public static class ChannelVo {

        private String channelName;

        private Long channelId;
    }

}
