package com.bizvane.members.facade.service.inner;


import com.bizvane.members.facade.models.po.MbrLevelRechargeRecordPO;
import com.bizvane.members.facade.vo.*;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;
import com.github.pagehelper.PageInfo;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


public interface PaidMemberService {
    /**
     * 获取付费会员列表
     * @param requestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData<PageInfo<PaidMemberResponseVo>> getPaidMemberList(PaidMemberRequestVo requestVo, SysAccountPO  sysAccountPO);

    /**
     * 导出付费会员列表
     * @param requestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData exportPaidMemberList(PaidMemberToExcelVo requestVo, SysAccountPO  sysAccountPO, HttpServletRequest request);

    /**
     * 获取付费会员列表
     * @param recordIds
     * @param sysAccountPO
     * @return
     */
    List<PaidMemberResponseVo> excelPaidMemberResponseVo(List<Long> recordIds , SysAccountPO  sysAccountPO);

    /**
     * 退款
     * @param refundVo
     * @param sysAccountPO
     * @return
     */
    ResponseData  paidMemberRefund(PaidMemberRefundVo refundVo, SysAccountPO  sysAccountPO);

    /**
     * 退款回调
     * @param callbackVO
     * @return
     */
    ResponseData paidMemberRefundCallback(PaidMemberRefundCallbackVO callbackVO);
}
