package com.bizvane.members.facade.models;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * 会员体系实体类
 *
 * @author houkai
 */
@Data
@NoArgsConstructor
@Table(name = "t_mbr_members_sys_def")
public class MembersSysModel extends BaseModel implements Serializable {

	private static final long serialVersionUID = 7727392002102113955L;

	@Id
	@ApiModelProperty(value = "会员体系id", name = "memberSysDefId", example = "会员体系id")
	private Long memberSysDefId;

	@ApiModelProperty(value = "会员体系编号", name = "memberSysCode", example = "会员体系编号")
	private String memberSysCode;

	@ApiModelProperty(value = "所属企业", name = "sysCompanyId", example = "所属企业")
	private Long sysCompanyId;

	@ApiModelProperty(value = "归属品牌", name = "brandId", example = "归属品牌")
	private Long brandId;

	@ApiModelProperty(value = "积分清零规则（月）", name = "resetRuleMonth", example = "积分清零规则（月）")
	private Integer resetRuleMonth;

	@ApiModelProperty(value = "积分清零规则（日）", name = "resetRuleDay", example = "积分清零规则（日）")
	private Integer resetRuleDay;

	@ApiModelProperty(value = "积分清零规则（清除多少年前）", name = "restBeforeYear", example = "积分清零规则（清除多少年前）")
	private Integer restBeforeYear;

	@ApiModelProperty(value = "线上会员卡号规则", name = "onlineMemberCardNoStandard", example = "线上会员卡号规则")
	private String onlineMemberCardNoStandard;

//    @ApiModelProperty(value = "新会员等级 ", name = "newMemberLevel", example = "新会员等级")
//    private String newMemberLevel;

	@ApiModelProperty(value = "默认开卡门店", name = "defaultStoreName", example = "默认开卡门店")
	private String defaultStoreName;

	@ApiModelProperty(value = "会员性别,女:0 男:1 未知:2", name = "gender", example = "会员性别,女:0 男:1 未知:2")
	private String gender;

	@ApiModelProperty(value = "是否清零: 1=是; 0=否", name = "clearZero", example = "是否清零: 1=是; 0=否")
	private Integer clearZero;

	@ApiModelProperty(value = "积分计算渠道1:crm,2:线下", name = "integralCalculateChannel", example = "积分计算渠道1:crm,2:线下")
	private Integer integralCalculateChannel;

	@ApiModelProperty(value = "会员卡号生成规则: 1=前缀+手机号; 2=前缀+流水号", name = "cardNoMethod", example = "会员卡号生成规则: 1=前缀+手机号; 2=前缀+流水号")
	private Integer cardNoMethod;

	@ApiModelProperty(value = "会员卡号前缀", name = "prefixion", example = "会员卡号前缀")
	private String prefixion;

	@ApiModelProperty(value = "起始流水号", name = "serialStart", example = "起始流水号")
	private String serialStart;

	@ApiModelProperty(value = "开卡门店id", name = "openCardStoreId", example = "开卡门店id")
	private Long openCardStoreId;

	@ApiModelProperty(value = "开卡等级id", name = "newLevelId", example = "开卡等级id")
	private Long newLevelId;

	@ApiModelProperty(value = "智慧门店授权状态", name = "taobaoAuthState", example = "智慧门店授权状态")
	private Integer taobaoAuthState;

	@ApiModelProperty(value="智慧门店授权日期",name="taobaoAuthDate",example="智慧门店授权日期")
	private Date taobaoAuthDate;

	@ApiModelProperty(value = "智慧门店店铺名称", name = "taobaoStoreName", example = "智慧门店店铺名称")
	private String taobaoStoreName;

	@ApiModelProperty(value = "智慧门店开卡店铺id", name = "taobaoStoreId", example = "智慧门店开卡店铺id")
	private Long taobaoOpenCardStoreId;

	@ApiModelProperty(value = "智慧门店开卡店铺name", name = "taobaoOpenCardStoreName", example = "taobaoOpenCardStoreName")
	private String taobaoOpenCardStoreName;

	@ApiModelProperty(value = "1=线上 2=线下", name = "canOnLine", example = "canOnLine")
	private Integer canOnLine;
//	@ApiModelProperty(value = "线上升级的时间", name = "canOnLine", example = "canOnLine")
//	private Date onLineTime;


	//2019-08-10新加
	@ApiModelProperty(value = "默认开卡导购",name = "openCardGuideId")
	private Long openCardGuideId;

	@ApiModelProperty(value = "开启默认门店是否变更。0：不开启，1：开启",name = "enableChangeMemberFirstStore")
	private Boolean enableChangeMemberFirstStore;

	@ApiModelProperty(value = "升级时间点 0次日凌晨统一升级 1实时升级",name = "openCardGuideId")
	private Integer levelUpTimePoint;

	@ApiModelProperty(value = "全量订单计算日期",name = "fullOrderCalcDate")
	private Date fullOrderCalcDate;

	@ApiModelProperty(value = "首次消费变更所属店铺范围店铺id集合（，分割）",name = "selectStoreIds")
	private String selectStoreIds;

    @ApiModelProperty(value = "开启默认导购是否变更。0：不开启，1：开启", name = "enableChangeMemberFirstGuide")
    private Boolean enableChangeMemberFirstGuide;

    @ApiModelProperty(value = "开启绑定是否变更店铺导购。0：不开启，1：开启", name = "enableChangeMemberBindGuide")
    private Boolean enableChangeMemberBindGuide;

	@ApiModelProperty(value = "付费会员卡升级开关 false 关闭 true 开启")
	private Boolean paidMembershipUpgradeSwitch;

	@ApiModelProperty(value = "付费会员卡续费设置 true:限制  flase:无限制")
	private Boolean paidMemberShipRenewalSetting;

	@ApiModelProperty(value = "有效期小于多少天时，支持续费 ")
	private Integer paidMemberShipRenewalDays;

}
