package com.bizvane.members.facade.enums;

public enum IntegralConsumeTypeEnum {

    /**
     * 积分调整返回结果类型 无
     */
    DEFAULT(0, "默认状态"),
    /**
     * 积分调整返回结果类型 成功
     */
    SUCCESS(1, "成功"),
    /**
     * 积分调整返回结果类型 线下及线下前失败
     */
    OFFLINE_FAILED_BEFORE(2, "线下及线下前失败"),
    /**
     * 积分调整返回结果类型 线下成功线上失败
     */
    ONLINE_FAILED_AFTER_OFFLINE(3, "线下成功线上失败"),
    /**
     * 积分调整返回结果类型 未知错误
     */
    UNKNOW(4, "未知错误");

    private Integer code;

    private String msg;

    IntegralConsumeTypeEnum(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static String getName(String code) {
        for (CardStatusEnum type : CardStatusEnum.values()) {
            if (code.equals(String.valueOf(type.getCode()))) {
                return type.getMsg();
            }
        }
        return "";
    }

}
