package com.bizvane.members.facade.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author SF
 */
@Data
public class MemberAuthorizeGetTaskRequestVo {

    @ApiModelProperty(name = "pageNumber", value = "页数")
    private Integer pageNumber;
    
    @ApiModelProperty(name = "pageSize", value = "每页数据量")
    private Integer pageSize;

    @ApiModelProperty(name = "mbrAuthorizeTaskName", value = "授权标题")
    private String mbrAuthorizeTaskName;

    @ApiModelProperty(name = "mbrAuthorizeTaskStartTime", value = "执行开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mbrAuthorizeTaskStartTime;

    @ApiModelProperty(name = "mbrAuthorizeTaskEndTime", value = "执行结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mbrAuthorizeTaskEndTime;

    @ApiModelProperty(name = "createDate", value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty(name = "status", value = "任务状态（-1，未执行；0：执行中；1：已结束 ；9已禁用）")
    private Integer status;

    @ApiModelProperty(name = "createUserName", value = "创建人")
    private String createUserName;



    @Override
    public String toString() {
        return "MemberAuthorizeGetTaskRequestVo{" +
                "pageNumber=" + pageNumber +
                ", pageSize=" + pageSize +
                ", mbrAuthorizeTaskName='" + mbrAuthorizeTaskName + '\'' +
                ", mbrAuthorizeTaskStartTime=" + mbrAuthorizeTaskStartTime +
                ", mbrAuthorizeTaskEndTime=" + mbrAuthorizeTaskEndTime +
                ", createDate=" + createDate +
                ", status=" + status +
                ", createUserName='" + createUserName + '\'' +
                '}';
    }
}
