package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.es.vo.MembersInfoSearchVo;
import com.bizvane.members.facade.vo.*;

import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import javax.servlet.http.HttpServletRequest;

/**
 * @author SF
 */
public interface MemberAuthorizeTaskService {
    /**
     * 添加会员授权任务
     * @param memberAuthorizeAddTaskRequestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData addAuthorizeTask(MemberAuthorizeAddTaskRequestVo memberAuthorizeAddTaskRequestVo, SysAccountPO sysAccountPO);


    /**
     * 删除会员授权任务
     * @param memberAuthorizeDeleteTaskRequestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData disableAuthorizeTask(MemberAuthorizeDeleteTaskRequestVo memberAuthorizeDeleteTaskRequestVo, SysAccountPO sysAccountPO);


    /**
     * 更新会员授权任务
     * @param memberAuthorizeUpdateTaskRequestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData updateAuthorizeTask(MemberAuthorizeUpdateTaskRequestVo memberAuthorizeUpdateTaskRequestVo, SysAccountPO sysAccountPO);


    /**
     * 获取会员授权任务
     * @param memberAuthorizeGetTaskRequestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData getAuthorizeTask(MemberAuthorizeGetTaskRequestVo memberAuthorizeGetTaskRequestVo, SysAccountPO sysAccountPO);




    /**
     * 获取会员授权信息详情
     * @param memberAuthorizeGetTaskItemRequestVo
     * @param sysAccountPO
     * @return
     */
    ResponseData getAuthorizeTaskItem(MemberAuthorizeGetTaskItemRequestVo memberAuthorizeGetTaskItemRequestVo, SysAccountPO sysAccountPO);


    /**
     * 根据taskNum获取taskVo
     * @param memberAuthorizeTaskNumber
     * @return
     */
    ResponseData getSingleAuthorizeTaskInfo(String memberAuthorizeTaskNumber);
}
