package com.bizvane.members.facade.vo;

import lombok.*;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

/**
 * @author dingshichen
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class BatchUpdateLevel361 {

    @NotNull
    private Long companyId;

    @NotEmpty
    private String cardNo;

    @NotEmpty
    private String erpId;

    @NotEmpty
    private String phone;

    @NotEmpty
    private String newLevelCode;

    private List<BrandLevel> brandMemberLevels = new ArrayList<>(4);

    /**
     * 添加需要修改的品牌会员等级
     * @param brandId
     * @param newLevelId
     */
    public void addBrandMemberLevel(Long brandId, Long newLevelId) {
        this.brandMemberLevels.add(new BrandLevel(brandId, newLevelId));
    }

    /**
     * 更新下线数据
     * @param consumer
     */
    public void updateSingleOffline(Consumer<BatchUpdateLevel361> consumer){
        consumer.accept(this);
    }

    /**
     * 循环更新多个品牌线上数据
     * @param consumer
     */
    public void updateAllOnline(Consumer<BrandLevel> consumer){
        brandMemberLevels.forEach(consumer);
    }

    /**
     * 更新到es
     * @param consumer
     */
    public void updateEs(Consumer<BatchUpdateLevel361> consumer){
        consumer.accept(this);
    }

    /**
     * 获取第一个品牌ID
     * @return
     */
    public Long getFirstBrandId() {
        return brandMemberLevels.get(0).getBrandId();
    }

    /**
     * 获取第一个品牌的目标等级ID
     * @return
     */
    public Long getFirstBrandNewLevelId() {
        return brandMemberLevels.get(0).getNewLevelId();
    }

    @Getter
    @AllArgsConstructor
    @NoArgsConstructor
    public static class BrandLevel {

        Long brandId;

        Long newLevelId;
    }
}
