package com.bizvane.members.facade.service.ur;

import com.bizvane.members.facade.ur.vo.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;

@FeignClient(value = "${feign.client.members.name}", path = "${feign.client.members.path}")
public interface UrOrderApiService {

    @RequestMapping(value = "/api/urOrder/getUrOrderRecord", method = RequestMethod.POST)
    ResponseData<PageInfo<MiniUrOrderResponseVo>> getUrOrderRecord(@RequestBody @Valid MiniUrOrderRequestVo miniUrOrderRequestVo);

    /**
     * 保存订单信息
     *
     * @param urSaveOrderRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/saveOrderForm", method = RequestMethod.POST)
    ResponseData<String> saveOrderForm(@RequestBody @Valid UrSaveOrderRequestVo urSaveOrderRequestVo);

    /**
     * 查询订单信息
     *
     * @param urOrderQueryRequestVo
     * @return
     */
    @RequestMapping(value = "/api/urOrder/queryOrderInfo", method = RequestMethod.POST)
    ResponseData<PageInfo<UrOrderQueryResponseVo>> queryOrderInfo(@RequestBody @Valid UrOrderQueryRequestVo urOrderQueryRequestVo);


    @RequestMapping(value = "/api/urOrder/updateOrderEvaluate", method = RequestMethod.POST)
    ResponseData<Integer> updateOrderEvaluate(@RequestBody @Valid UrOrderUpdateVo urOrderUpdateVo);
}
