package com.bizvane.members.facade.service.api;

import com.bizvane.members.facade.service.card.request.IntegralChangeForTmallReqVo;
import com.bizvane.members.facade.service.card.request.IntegralChangeRequestModel;
import com.bizvane.members.facade.service.card.response.IntegralChangeResponseModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @Author: Hou Hong Bin
 * @CreateTime: 2018/8/18.
 */
@FeignClient(value = "${feign.client.members.name}",path = "${feign.client.members.path}")
public interface IntegralChangeApiService {
    /**
     * 积分变动操作
     * @param integralChangeRequestModel
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperate", method = RequestMethod.POST)
    public IntegralChangeResponseModel integralChangeOperate(@RequestBody IntegralChangeRequestModel integralChangeRequestModel);

    /**
     * 积分变动操作
     * @param vo
     * @return
     */
    @RequestMapping(value = "/api/integralChangeOperateForTmall", method = RequestMethod.POST)
    public IntegralChangeResponseModel integralChangeOperateForTmall(@RequestBody IntegralChangeForTmallReqVo vo);
}
