package com.bizvane.members.facade.vo.qywx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author baofeng@bizvane.cn
 * @createTime 2022-09-08 11:51:42
 * @description: 商品秀订单商品数量查询对象
 */
@ApiModel(value = "商品秀订单商品数量查询对象")
@Getter
@Setter
@Builder
public class MallShareOrderCommodityNumRequestVO {

    @NotNull(message = "企业ID不能为空")
    @ApiModelProperty(name = "sysCompanyId", value = "企业ID", required = true, example = "1L")
    private Long sysCompanyId;

    @NotNull(message = "品牌ID不能为空")
    @ApiModelProperty(name = "sysBrandId", value = "品牌ID", required = true, example = "1L")
    private Long sysBrandId;

    @ApiModelProperty(name = "orderNoList", value = "订单编号列表", example = "[]")
    private List<String> orderNoList;

}
