package com.bizvane.members.facade.ur.vo;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class UrSaveOrderRequestVo {

    @NotNull
    private Long sysCompanyId;
    @NotNull
    private Long brandId;

    private String shopId;
    @NotNull
    private String billNo;
    private Date billDate;
    private BigDecimal totalAmount;
    private Integer totalQty;
    private String cashier;
    private String cardCode;
    @NotNull
    private String mobileTel;

    private Date originalOrderDate;
    @NotNull
    private List<UrSalePayDetailVo> salePayDetail;
    @NotNull
    private List<UrSaveOrderDetailVo> saleDetail;

    private String channel;

    private Boolean isReTryMq;

    //是否允许非会销订单进入(mq重试次数超过十次)
    private Boolean allowNonMember;

    private String originalOrderNo;

    private String offlineLevelCode;

    private Date placeOrderTime;

}
