package com.bizvane.members.facade.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 天猫会员通店铺授权状态枚举
 * @author huangxinliu
 * @date: 2021/1/26 14:56
 */
@AllArgsConstructor
@Getter
public enum MbrTmallConfigTaobaoAuthStateEnum {

    UNAUTHORIZED(1, "未授权"),
    AUTHORIZED(2, "已授权"),
    ;

    private Integer code;
    private String msg;

    public static String getMsg(Integer code){
        for (MbrTmallConfigTaobaoAuthStateEnum c: MbrTmallConfigTaobaoAuthStateEnum.values()){
            if(c.getCode().equals(code)){
                return c.getMsg();
            }
        }
        return null;
    }

}
