package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class IntegralMallRefundCheckCalculateRes implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("退单系统编号code")
    private String integralMallRefundOrderCode;

    @ApiModelProperty("退单编号")
    private String refundOrderNo;

    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

    @ApiModelProperty("申请时间")
    private LocalDateTime applyDate;

    @ApiModelProperty("申请类型 1仅退款")
    private Integer applyType;

    @ApiModelProperty("申请备注")
    private String applyRemark;

    @ApiModelProperty("正单订单系统编号 FK")
    private String integralMallOrderCode;

    @ApiModelProperty("正单订单编号")
    private String originOrderNo;

    @ApiModelProperty("订单类型 1优惠券 2实物")
    private Integer orderType;

    @ApiModelProperty("兑换数量")
    private Integer orderExchangeNum;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer orderPayType;

    @ApiModelProperty("支付积分数量")
    private Integer orderPayIntegralAmount;

    @ApiModelProperty("支付现金金额 单位元")
    private BigDecimal orderPayCashAmount;

    @ApiModelProperty("退单金额 单位元")
    private BigDecimal refundCashAmount;

    @ApiModelProperty("退回积分")
    private Integer refundIntegral;

    @ApiModelProperty("退回积分有效期天数")
    private Integer refundIntegralExpiredDays;

    @ApiModelProperty("可退券集合")
    private List<String> canInvalidCouponEntityCodeList;
}
