package com.bizvane.airport.mall.feign.model.req;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 积分订单明细
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分订单")
public class IntegralMallOrderOneReq implements Serializable {
    public static final long serialVersionUID = 1L;

    @ApiModelProperty("订单系统编码")
    @NotBlank(message = "订单系统编码不能为空")
    private String integralMallOrderCode;

    @NotBlank(message = "会员系统编号code不能为空")
    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

}
