package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单发货")
public class IntegralMallOrderDeliveryReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号")
    @NotBlank(message = "系统编号不能为空", groups = {UpdateValidation.class})
    private String integralMallOrderCode;

    @NotBlank(message = "快递公司名字不能为空", groups = {UpdateValidation.class})
    @ApiModelProperty("快递公司名字")
    private String courierCompanyName;

    @NotBlank(message = "快递公司编码不能为空", groups = {UpdateValidation.class})
    @ApiModelProperty("快递公司编码")
    private String courierCompanyCode;

    @NotBlank(message = "快递单号不能为空", groups = {UpdateValidation.class})
    @ApiModelProperty("快递单号")
    private String courierNo;

    @ApiModelProperty("更新人code")
    @NotBlank(message = "更新人code不能为空", groups = {UpdateValidation.class})
    private String modifiedUserCode;

    @ApiModelProperty("更新人姓名")
    @NotBlank(message = "更新人姓名不能为空", groups = {UpdateValidation.class})
    private String modifiedUserName;

}
