package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.IntegralProductDetailReq;
import com.bizvane.airport.mall.feign.model.req.IntegralProductPageReq;
import com.bizvane.airport.mall.feign.model.req.IntegralProductStatusReq;
import com.bizvane.airport.mall.feign.model.res.IntegralProductDetailRes;
import com.bizvane.airport.mall.feign.model.res.IntegralProductPageRes;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.DeleteValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/product")
@Api("积分商城商品管理")
public interface IntegralMallProductFeign {

    @ApiOperation(value = "新增")
    @PostMapping("/add")
    public ResponseData<Boolean> add(@RequestBody @Validated(CreateValidation.class) IntegralProductDetailReq reqVO);

    @ApiOperation(value = "编辑")
    @PostMapping("/update")
    public ResponseData<Boolean> update(@RequestBody @Validated(UpdateValidation.class) IntegralProductDetailReq reqVO);

    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    public ResponseData<Boolean> delete(@RequestBody @Validated(DeleteValidation.class) IntegralProductDetailReq reqVO);

    @ApiOperation(value = "分页")
    @PostMapping("/page")
    public ResponseData<PageInfo<IntegralProductPageRes>> page(@RequestBody IntegralProductPageReq reqVO);

    @ApiOperation(value = "详情")
    @PostMapping("/get")
    public ResponseData<IntegralProductDetailRes> get(@RequestParam("integralProductCode") String integralProductCode);

    @ApiOperation(value = "上架")
    @PostMapping("/up")
    public ResponseData<Boolean> up(@RequestBody @Validated(UpdateValidation.class) IntegralProductStatusReq reqVO);

    @ApiOperation(value = "下架")
    @PostMapping("/down")
    public ResponseData<Boolean> down(@RequestBody @Validated(UpdateValidation.class) IntegralProductStatusReq reqVO);

}

