package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.*;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderCheckExchangeRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderPageRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallOrderRes;
import com.bizvane.airport.mall.feign.model.res.PrepayWithRequestPaymentRes;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/order")
@Api("积分商城订单管理")
public interface IntegralMallOrderFeign {

    @ApiOperation(value = "兑换校验")
    @PostMapping("/checkExchange")
    public ResponseData<IntegralMallOrderCheckExchangeRes> checkExchange(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderCheckExchangeReq reqVO);

    @ApiOperation(value = "新增")
    @PostMapping("/add")
    public ResponseData<PrepayWithRequestPaymentRes> add(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderAddReq reqVO);

    @ApiOperation(value = "支付")
    @PostMapping("/prepay")
    public ResponseData<PrepayWithRequestPaymentRes> prepay(@RequestBody @Validated(CreateValidation.class) PrepareOrderReq reqVO);

    @ApiOperation(value = "分页")
    @PostMapping("/page")
    public ResponseData<PageInfo<IntegralMallOrderPageRes>> page(@RequestBody IntegralMallOrderPageReq reqVO);

    @ApiOperation(value = "详情")
    @PostMapping("/detail")
    public ResponseData<IntegralMallOrderRes> detail(@RequestBody @Validated IntegralMallOrderOneReq reqVO);

    @ApiOperation(value = "发货")
    @PostMapping("/delivery")
    public ResponseData<Boolean> delivery(@RequestBody @Validated(UpdateValidation.class) IntegralMallOrderDeliveryReq reqVO);

    @ApiOperation(value = "取消订单")
    @PostMapping("/cancel")
    public ResponseData<Boolean> cancel(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderCancelReq reqVO);

    @ApiOperation(value = "确认收货")
    @PostMapping("/confirmReceipt")
    public ResponseData<Boolean> confirmReceipt(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderConfirmReceiptReq reqVO);


    @ApiOperation(value = "完成订单")
    @PostMapping("/complete")
    public ResponseData<Boolean> complete(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderCompleteReq reqVO);

    @ApiOperation(value = "扫码自提")
    @PostMapping("/scanCode")
    public ResponseData<Boolean> scanCode(@RequestBody @Validated(CreateValidation.class) IntegralMallOrderScanCodeReq reqVO);



}

