package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.*;
import com.bizvane.airport.mall.feign.model.res.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/merchant")
@Api("积分商城商户管理")
public interface IntegralMallMerchantFeign {

    @ApiOperation(value = "分页")
    @PostMapping("/page")
    public ResponseData<PageInfo<IntegralMallMerchantPageRes>> page(@RequestBody IntegralMallMerchantPageReq reqVO);

    @ApiOperation(value = "启用禁用", notes = "启用禁用", httpMethod = "POST")
    @PostMapping("/changeStatus")
    public ResponseData<Boolean> changeStatus(@RequestBody IntegralMallMerchantStatusReq statusReq);

    @ApiOperation(value = "保存商户记录", notes = "保存商户记录", httpMethod = "POST")
    @PostMapping("/addOrUpdate")
    ResponseData<Boolean> addOrUpdate(@RequestBody  @Valid IntegralMallMerchantAddOrUpdateReq requestVO);

    @ApiOperation(value ="获取商户详情", notes = "获取商户详情", httpMethod = "POST")
    @PostMapping("/detailMerchant")
    public ResponseData<IntegralMallMerchantDetailRes> detailMerchant(@RequestBody IntegralMallMerchantDetailReq detailReq);

    @ApiOperation(value ="启用状态商户信息", notes = "启用状态商户信息", httpMethod = "POST")
    @PostMapping("/detailMerchantByState")
    public ResponseData<List<IntegralMallMerchantDetailRes>> detailMerchantByState(@RequestBody IntegralMallMerchantDetailByStateReq byStateReq);

}

