package com.bizvane.airport.mall.feign.model.res;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

@Data
public class IntegralProductSpecRes implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号code")
    private String integralProductSpecCode;

    @ApiModelProperty("父级系统编号code")
    private String pIntegralProductSpecCode;

    @NotBlank(message = "规格编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("规格名称")
    private String specName;

    @ApiModelProperty("子规格集合")
    private List<IntegralProductSpecRes> children;

}
