package com.bizvane.airport.mall.feign.model.req;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

@Data
public class IntegralProductStatusReq implements Serializable {
    public static final long serialVersionUID = 1L;

    @ApiModelProperty("系统code")
    @NotEmpty(message = "系统code不能为空", groups = {UpdateValidation.class})
    private List<String> integralProductCodeList;

    @ApiModelProperty("状态 0下架 1上架")
    @NotBlank(message = "状态不能为空", groups = {UpdateValidation.class})
    private Boolean state;

    @ApiModelProperty("创建人code")
    @NotBlank(message = "创建人code不能为空", groups = {UpdateValidation.class})
    private String modifiedUserCode;

    @ApiModelProperty("创建人姓名")
    @NotBlank(message = "创建人姓名不能为空", groups = {UpdateValidation.class})
    private String modifiedUserName;
}
