package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.enumutils.IntegralMallOrderStatusOperationTypeEnum;
import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class IntegralMallOrderCompleteReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号")
    @NotBlank(message = "系统编号不能为空", groups = {CreateValidation.class})
    private String integralMallOrderCode;

    @ApiModelProperty("会员系统编号code")
    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    private String mbrMemberCode;

    @ApiModelProperty("操作类型 1.用户操作 2.系统操作 3.后台操作")
    @NotNull(message = "操作类型不能为空", groups = {CreateValidation.class})
    private Integer operationType;

    @ApiModelProperty("操作描述")
    @NotBlank(message = "操作描述不能为空", groups = {CreateValidation.class})
    private String operationDesc;

    @ApiModelProperty("更新人code")
    private String modifiedUserCode;

    @ApiModelProperty("更新人姓名")
    private String modifiedUserName;

    @AssertTrue(message = "操作人信息不能为空", groups = {CreateValidation.class})
    public boolean checkModifiedUserOnlyUserCancel() {
        return IntegralMallOrderStatusOperationTypeEnum.USER_OPERATION.getType().equals(operationType) ? StringUtils.isNotBlank(modifiedUserCode) && StringUtils.isNotBlank(modifiedUserName) : true;
    }
}
