package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.DeleteValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.Valid;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 积分商城规格类型
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Data
@ApiModel(description = "积分商城规格类型")
public class IntegralProductSpecDetailReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @NotBlank(message = "系统code不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    @ApiModelProperty("系统编号code")
    private String integralProductSpecCode;

    @NotBlank(message = "规格编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("规格名称")
    private String specName;

    @NotBlank(message = "创建人code不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("创建人code")
    private String createUserCode;

    @NotBlank(message = "创建人姓名不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("创建人姓名")
    private String createUserName;

    @NotBlank(message = "更新人code不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    @ApiModelProperty("更新人code")
    private String modifiedUserCode;

    @NotBlank(message = "更新人姓名不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    @ApiModelProperty("更新人姓名")
    private String modifiedUserName;

    @NotBlank(message = "数据有效性不能为空", groups = {DeleteValidation.class})
    @ApiModelProperty("数据有效性")
    private Boolean valid;

    @ApiModelProperty("子集")
    @NotEmpty(message = "子集不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private List<IntegralProductSpecChildrenReq> childrenList;

    @AssertTrue(message = "子集名称不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    public boolean isChildrenNameValid() {
        if (childrenList == null) {
            return true;
        }
        return childrenList.stream().allMatch(item -> StringUtils.isNotBlank(item.getSpecName()));
    }
}
