package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.requestinfo.BasePageReq;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单")
public class IntegralMallOrderPageReq extends BasePageReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单类型 1优惠券 2实物")
    private Integer orderType;

    @ApiModelProperty("订单状态 0待付款 1已付款/待发货/待自提 2已发货（实物） 3已签收/已自提（实物）4已完成 5已退货 6已取消")
    private Integer state;

    @ApiModelProperty("配送类型：1快递 2自提")
    private Integer deliveryType;

    @ApiModelProperty("自提商户code列表")
    private List<String> deliveryMerchantCodeList;

    @ApiModelProperty("会员系统code")
    private String memberCode;

    @ApiModelProperty("会员卡号")
    private String mbrCardNo;

    @ApiModelProperty("会员手机号")
    private String mbrPhoneEncrypt;

    @ApiModelProperty("积分商城商户code列表")
    private List<String> integralMallMerchantCodes;

    @ApiModelProperty("商户名称")
    private String integralMallMerchantName;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer payType;

    @ApiModelProperty("商品编码")
    private String orderProductNo;

    @ApiModelProperty("商品名称")
    private String orderProductName;

    @ApiModelProperty("兑换时间开始条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startExchangeTime;

    @ApiModelProperty("兑换时间结束条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endExchangeTime;

    @ApiModelProperty("发货时间开始条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startDeliveryDate;

    @ApiModelProperty("发货时间结束条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endDeliveryDate;

    @ApiModelProperty("收货时间/自提时间开始条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime startReceiveDate;

    @ApiModelProperty("收货时间/自提时间结束条件")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime endReceiveDate;



}
