package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单")
public class IntegralMallOrderPageRes implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号")
    private String integralMallOrderCode;

    @ApiModelProperty("订单编号")
    private String orderNo;

    @ApiModelProperty("订单类型 1优惠券 2实物")
    private Integer orderType;

    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

    @ApiModelProperty("积分商品系统编号code")
    private String integralProductCode;

    @ApiModelProperty("商品编码")
    private String orderProductNo;

    @ApiModelProperty("商品名称")
    private String orderProductName;

    @ApiModelProperty("商品主图")
    private String productMainImg;

    @ApiModelProperty("积分商品sku系统编码")
    private String integralProductSkuCode;

    @ApiModelProperty("商品sku编号")
    private String productSkuNo;

    @ApiModelProperty("sku图片")
    private String productSkuImg;

    @ApiModelProperty("规格组合名称（以逗号分隔）")
    private String productSkuSpecNames;

    @ApiModelProperty("商品积分价格")
    private Integer productIntegralPrice;

    @ApiModelProperty("商品现金价格，单位元")
    private BigDecimal productCashPrice;

    @ApiModelProperty("兑换数量")
    private Integer exchangeNum;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer payType;

    @ApiModelProperty("支付积分数量")
    private Integer payIntegralAmount;

    @ApiModelProperty("支付现金金额 单位元")
    private BigDecimal payCashAmount;

    @ApiModelProperty("兑换时间")
    private LocalDateTime exchangeTime;

    @ApiModelProperty("订单状态 0待付款 1已付款/待发货/待自提 2已发货（实物） 3已签收/已自提（实物）4已完成 5已退货 6已取消")
    private Integer state;

    @ApiModelProperty("会员卡号")
    private String mbrCardNo;

    @ApiModelProperty("会员姓名")
    private String mbrName;

    @ApiModelProperty("会员手机号")
    private String mbrPhone;

    @ApiModelProperty("会员等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("会员等级名称")
    private String mbrLevelDefName;

    @ApiModelProperty("支付系统编号流水code")
    private String integralOrderTradeRecordCode;

    @ApiModelProperty("微信支付生成的订单号")
    private String transactionId;

    @ApiModelProperty("积分支付系统生成的积分流水code")
    private String mbrIntegralRecordCode;

    @ApiModelProperty("配送类型：0无需配置 1快递 2自提")
    private Integer deliveryType;

    @ApiModelProperty("收货人")
    private String consigneeName;

    @ApiModelProperty("收货人电话")
    private String consigneeMobile;

    @ApiModelProperty("收货人电话加密")
    private String consigneeMobileEncrypt;

    @ApiModelProperty("收货省份")
    private String consigneeProvince;

    @ApiModelProperty("收货城市")
    private String consigneeCity;

    @ApiModelProperty("收货行政区")
    private String consigneeDistrict;

    @ApiModelProperty("收货具体地址")
    private String consigneeAddress;

    @ApiModelProperty("买家留言")
    private String userComments;
}
