package com.bizvane.airport.mall.feign.model.res;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * <p>
 * 积分商城-基础配置
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Data
@ApiModel(description = "积分商城-基础配置")
public class IntegralConfigRes implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号code")
    private String integralConfigCode;

    @ApiModelProperty(value = "已发货订单自动签收时间(天)", example = "1", required = true)
    @NotBlank(message = "已发货订单自动签收时间不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer awaitOrderDelivery;

    @ApiModelProperty(value = "已签收订单自动关闭退换时间(天)", example = "1", required = true)
    @NotBlank(message = "已签收订单自动关闭退换时间不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer awaitOrderReturnable;

    @ApiModelProperty(value = "未支付订单自动关闭时间(分钟)", example = "1", required = true)
    @NotBlank(message = "未支付订单自动关闭时间不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer awaitOrderCancel;

    @ApiModelProperty(value = "积分规则", example = "1", required = true)
    @NotBlank(message = "积分规则不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String configRule;

    @ApiModelProperty(value = "是否开启客服功能", example = "1", required = true)
    @NotBlank(message = "是否开启客服功能不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Boolean customerService;

    @ApiModelProperty(value = "自提门店列表,逗号隔开", example = "1", required = false)
    private String wholeStoreCodes;

}
