package com.bizvane.airport.mall.feign.model.res;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城退单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城退单")
public class IntegralMallRefundOrderRes implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("退单系统编号code")
    private String integralMallRefundOrderCode;

    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

    @ApiModelProperty("会员卡号")
    private String mbrCardNo;

    @ApiModelProperty("会员姓名")
    private String mbrName;

    @ApiModelProperty("会员手机号")
    private String mbrPhone;

    @ApiModelProperty("会员等级code")
    private String mbrLevelDefCode;

    @ApiModelProperty("会员等级名称")
    private String mbrLevelDefName;

    @ApiModelProperty("申请时间")
    private LocalDateTime applyDate;

    @ApiModelProperty("申请类型 1仅退款")
    private Integer applyType;

    @ApiModelProperty("申请备注")
    private String applyRemark;

    @ApiModelProperty("退单编号")
    private String refundOrderNo;

    @ApiModelProperty("正单订单系统编号 FK")
    private String integralMallOrderCode;

    @ApiModelProperty("正单订单商品系统code")
    private String orderIntegralProductCode;

    @ApiModelProperty("商品编码")
    private String orderProductNo;

    @ApiModelProperty("商品名称")
    private String orderProductName;

    @ApiModelProperty("兑换数量")
    private Integer orderExchangeNum;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    private Integer orderPayType;

    @ApiModelProperty("支付积分数量")
    private Integer orderPayIntegralAmount;

    @ApiModelProperty("支付现金金额 单位元")
    private BigDecimal orderPayCashAmount;

    @ApiModelProperty("兑换时间")
    private LocalDateTime orderExchangeTime;

    @ApiModelProperty("支付系统编号流水code")
    private String orderIntegralOrderTradeRecordCode;

    @ApiModelProperty("微信支付生成的订单号")
    private String orderTransactionId;

    @ApiModelProperty("积分支付系统生成的积分流水code")
    private String orderMbrIntegralRecordCode;

    @ApiModelProperty("退单金额 单位元")
    private BigDecimal refundCashAmount;

    @ApiModelProperty("退回积分")
    private Integer refundIntegral;

    @ApiModelProperty("退回积分有效期天数")
    private Integer refundIntegralExpiredDays;

    @ApiModelProperty("退回积分过期时间")
    private LocalDateTime refundIntegralExpiredTime;

    @ApiModelProperty("退款支付系统编号流水code")
    private String refundIntegralOrderTradeRecordCode;

    @ApiModelProperty("退款微信支付生成的订单号")
    private String refundTransactionId;

    @ApiModelProperty("退款积分支付系统生成的积分流水code")
    private String refundMbrIntegralRecordCode;

    @ApiModelProperty("审核备注")
    private String checkRemark;

    @ApiModelProperty("审核人系统编号code")
    private String checkUserCode;

    @ApiModelProperty("审核人姓名")
    private String checkUserName;

    @ApiModelProperty("审核时间")
    private LocalDateTime checkDate;

    @ApiModelProperty("退单状态 1待审核 2待退款 3已退款 4已驳回")
    private Integer state;
}
