package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 积分商品
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商品")
public class IntegralProductDetailReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统code")
    @NotBlank(message = "系统code不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    private String integralProductCode;


    @ApiModelProperty("所属机构编号")
    @NotBlank(message = "所属机构编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String airportNoOrg;

    @ApiModelProperty("商品分类系统code")
    @NotBlank(message = "商品分类系统code不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String productCategoryCode;

    @ApiModelProperty("商品编码")
    @NotBlank(message = "商品编码不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String productNo;

    @ApiModelProperty("商品名称")
    @NotBlank(message = "商品名称不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String productName;

    @ApiModelProperty("商品主图")
    @NotBlank(message = "商品主图不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String productMainImg;

    @ApiModelProperty("支付方式：1积分 2现金 3积分+现金")
    @NotNull(message = "支付方式不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer payType;

    @ApiModelProperty("积分价格")
    @NotNull(message = "积分价格不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer integralPrice;

    @ApiModelProperty("现金价格 单位元")
    @NotNull(message = "现金价格不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private BigDecimal cashPrice;

    @ApiModelProperty("商品成本 单位元")
    @NotNull(message = "商品成本不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private BigDecimal costPrice;

    @ApiModelProperty("商品详细规格参数 (JSON格式)")
    private String detailSpecJson;

    @ApiModelProperty("每人限兑数量")
    @NotNull(message = "每人限兑数量不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer countPerLimit;

    @ApiModelProperty("库存数量")
    @NotNull(message = "库存数量不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer stockNum;

    @ApiModelProperty("虚拟兑换数量")
    @NotNull(message = "虚拟兑换数量不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer virtualExchangeNum;

    @ApiModelProperty("适用会员范围类型 1全部会员 2会员等级")
    @NotNull(message = "适用会员范围类型不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer memberRangeType;

    @ApiModelProperty("会员等级code，逗号拼接")
    @NotBlank(message = "适用会员范围不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String memberLevelCode;

    @ApiModelProperty("排序")
    @NotNull(message = "排序不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer sort;

    @ApiModelProperty("是否热门 0否1是")
    @NotNull(message = "是否热门不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Boolean hotState;

    @ApiModelProperty("商品类型 1优惠券 2实物")
    @NotNull(message = "商品类型不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer productType;

    @ApiModelProperty("优惠券商品类型 0无需配置 1普通优惠券")
    @NotNull(message = "优惠券商品类型不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Integer productCouponType;

    @ApiModelProperty("优惠券商品定义系统code, 多个逗号隔开")
    @NotBlank(message = "优惠券商品定义系统code不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String productCouponCode;

    @ApiModelProperty("状态 0下架 1上架")
    @NotBlank(message = "状态不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private Boolean state;

    @ApiModelProperty("商品轮播图 英文逗号拼接")
    @NotBlank(message = "商品轮播图不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String carouselImg;

    @ApiModelProperty("兑换说明")
    @NotBlank(message = "兑换说明不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    private String exchangeDesc;

    @ApiModelProperty("定时上架时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime upFixedTime;

    @ApiModelProperty("定时下架时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime downFixedTime;

    @ApiModelProperty("商品详情内容")
    private String productDetailContent;

    @ApiModelProperty("配送方式 0无需配置 1物流配送 2到店自提 3客户自选")
    private Integer deliveryType;

    @ApiModelProperty("快递费用类型 0无需配置 1固定费用 2包邮")
    private Integer deliveryPriceType;

    @ApiModelProperty("物流费用")
    private Integer deliveryPrice;

    @ApiModelProperty("自提门店类型 0无需配置 1统一设置 2独立设置")
    private Integer wholeStoreType;

    @ApiModelProperty("自提门店列表,逗号隔开")
    private String wholeStoreCodes;

    @ApiModelProperty("SKU 明细列表")
    private List<IntegralProductSkuReq> skuList;

    @ApiModelProperty("创建人code")
    @NotBlank(message = "创建人code不能为空", groups = {CreateValidation.class})
    private String createUserCode;

    @ApiModelProperty("创建人姓名")
    @NotBlank(message = "创建人姓名不能为空", groups = {CreateValidation.class})
    private String createUserName;

    @ApiModelProperty("更新人code")
    @NotBlank(message = "更新人code不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    private String modifiedUserCode;

    @ApiModelProperty("更新人姓名")
    @NotBlank(message = "更新人姓名不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    private String modifiedUserName;

}
