package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.enumutils.IntegralMallProductTypeEnum;
import com.bizvane.utils.validation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 积分商城订单
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城订单")
public class IntegralMallOrderAddReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统编号")
    @NotBlank(message = "系统编号不能为空", groups = {UpdateValidation.class})
    private String integralMallOrderCode;

    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("会员系统编号code")
    private String mbrMemberCode;

    @NotBlank(message = "会员openid不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("会员openid")
    private String mbrOpenid;

    @ApiModelProperty("商品类型 1优惠券 2实物")
    @NotBlank(message = "商品类型不能为空", groups = {CreateValidation.class})
    private Integer productType;

    @ApiModelProperty("积分商品系统编号code")
    @NotBlank(message = "积分商品系统编号code不能为空", groups = {CreateValidation.class})
    private String integralProductCode;

    @ApiModelProperty("兑换数量")
    @NotBlank(message = "兑换数量不能为空", groups = {CreateValidation.class})
    private Integer exchangeNum;

    @ApiModelProperty("积分商品sku系统编码")
    private String integralProductSkuCode;

    @ApiModelProperty("配送类型：0无需配置 1快递 2自提")
    private Integer deliveryType;

    @ApiModelProperty("收货人")
    private String consigneeName;

    @ApiModelProperty("收货人电话")
    private String consigneeMobile;

    @ApiModelProperty("收货省份")
    private String consigneeProvince;

    @ApiModelProperty("收货城市")
    private String consigneeCity;

    @ApiModelProperty("收货行政区")
    private String consigneeDistrict;

    @ApiModelProperty("收货具体地址")
    private String consigneeAddress;

    @ApiModelProperty("买家留言")
    private String userComments;

    @ApiModelProperty("自提商户code")
    private String deliveryMerchantCode;

    @ApiModelProperty("自提商户名称")
    private String deliveryMerchantName;

    @ApiModelProperty("预约自提时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private LocalDateTime appointmentDeliveryTime;

    @AssertTrue(message = "积分商品sku系统编码不能为空", groups = {CreateValidation.class})
    public boolean checkIntegralProductSkuCode() {
        return IntegralMallProductTypeEnum.INTEGRAL_PRODUCT.getType().equals(productType) ? StringUtils.isNotBlank(integralProductSkuCode) : true;
    }
}
