package com.bizvane.airport.mall.feign.model.enums;

public enum IntegralProductSortFieldEnum {

    /**
     * 排序
     */
    SORT("sort", "排序"),

    /**
     * 剩余库存
     */
    REMAIN_NUM("remain_num", "剩余库存"),

    /**
     * 创建时间
     */
    CREATE_DATE("create_date", "创建时间");

    private String code;
    private String desc;

    IntegralProductSortFieldEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static IntegralProductSortFieldEnum getByCode(String code) {
        for (IntegralProductSortFieldEnum value : values()) {
            if (value.getCode().equals(code)) {
                return value;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
