package com.bizvane.airport.mall.feign.service;

import com.alibaba.fastjson.JSONObject;
import com.bizvane.utils.responseinfo.ResponseData;
import io.swagger.annotations.Api;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/payCallback")
@Api("积分商城回调管理")
public interface PayCallbackFeign {

    @PostMapping("/payNotice")
    public ResponseData<String> payNotice(@RequestBody JSONObject req);

    @PostMapping("/refundNotice")
    public ResponseData<String> refundNotice(@RequestBody JSONObject req);
}
