package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class PrepareOrderReq implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("积分订单code")
    @NotBlank(message = "积分订单code不能为空", groups = {CreateValidation.class})
    private String integralMallOrderCode;

    @ApiModelProperty("会员系统编号code")
    @NotBlank(message = "会员系统编号code不能为空", groups = {CreateValidation.class})
    private String mbrMemberCode;

    @NotBlank(message = "用户openid不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("用户openid")
    private String openid;


}
