package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * <p>
 * 积分商城商品分类
 * </p>
 *
 * @author bizvane
 * @since 2024-11-06
 */
@Getter
@Setter
@ApiModel(description = "积分商城商品分类")
public class IntegralProductCategoryDetailReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("系统code")
    @NotBlank(message = "系统code不能为空", groups = {UpdateValidation.class, DeleteValidation.class})
    private String integralProductCategoryCode;

    @NotBlank(message = "所属机构名称不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("商品分类名称")
    private String categoryName;

    @NotBlank(message = "所属机构编号不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("商品分类编号")
    private String categoryNo;

    @NotBlank(message = "分类图片URL不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("分类图片URL")
    private String categoryImgUrl;

    @NotBlank(message = "分类图标URL不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("分类图标URL")
    private String categoryIconUrl;

    @NotBlank(message = "分类描述不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("分类描述")
    private String categoryDesc;

    @ApiModelProperty("二维码URL")
    private String qrcodeUrl;

    @NotBlank(message = "是否展示在积分商城不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("是否展示在积分商城 0否1是")
    private Boolean displayInMall;

    @NotBlank(message = "排序不能为空", groups = {CreateValidation.class, UpdateValidation.class})
    @ApiModelProperty("排序")
    private Integer sort;

    @NotBlank(message = "系统code不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("创建人code")
    private String createUserCode;

    @NotBlank(message = "系统code不能为空", groups = {CreateValidation.class})
    @ApiModelProperty("创建人名称")
    private String createUserName;

    @NotBlank(message = "系统code不能为空", groups = {UpdateValidation.class})
    @ApiModelProperty("更新人code")
    private String modifiedUserCode;

    @NotBlank(message = "修改人名称不能为空", groups = {UpdateValidation.class})
    @ApiModelProperty("修改人名称")
    private String modifiedUserName;

    @ApiModelProperty("数据有效性")
    @NotNull(message = "数据有效性不能为空", groups = {DeleteValidation.class})
    private Boolean valid;

}
