package com.bizvane.airport.mall.feign.service;

import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundCheckCalculateReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderAddReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderCheckReq;
import com.bizvane.airport.mall.feign.model.req.IntegralMallRefundOrderPageReq;
import com.bizvane.airport.mall.feign.model.res.IntegralMallRefundCheckCalculateRes;
import com.bizvane.airport.mall.feign.model.res.IntegralMallRefundOrderRes;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


@FeignClient(value="${feign.client.integral-mall.name}",path="${feign.client.integral-mall.path}/refundOrder")
@Api("积分商城售后管理")
public interface IntegralMallRefundOrderFeign {

    @ApiOperation(value = "新增")
    @PostMapping("/add")
    public ResponseData<Boolean> add(@RequestBody @Validated(CreateValidation.class) IntegralMallRefundOrderAddReq reqVO);

    @ApiOperation(value = "分页")
    @PostMapping("/page")
    public ResponseData<PageInfo<IntegralMallRefundOrderRes>> page(@RequestBody IntegralMallRefundOrderPageReq reqVO);

    @ApiOperation(value = "审核")
    @PostMapping("/check")
    public ResponseData<Boolean> check(@RequestBody @Validated(UpdateValidation.class) IntegralMallRefundOrderCheckReq reqVO);

    @ApiOperation(value = "退款审核计算")
    @PostMapping("/checkCalculate")
    public ResponseData<IntegralMallRefundCheckCalculateRes> checkCalculate(@RequestBody @Validated IntegralMallRefundCheckCalculateReq reqVO);


}

