package com.bizvane.airport.mall.feign.model.req;

import com.bizvane.utils.validation.CreateValidation;
import com.bizvane.utils.validation.DeleteValidation;
import com.bizvane.utils.validation.UpdateValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

@Getter
@Setter
@ApiModel(description = "积分商城商户")
public class IntegralMallMerchantAddOrUpdateReq implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("积分商城商户code")
    @NotBlank(message = "积分商城商户code不能为空")
    private String integralMallMerchantCode;

    @ApiModelProperty("商户编码")
    @NotBlank(message = "商户编码不能为空")
    private String integralMallMerchantNo;

    @ApiModelProperty("商户名称")
    @NotBlank(message = "商户名称不能为空")
    private String integralMallMerchantName;

    @ApiModelProperty("关联业务商户")
    @NotBlank(message = "关联业务商户不能为空")
    private String businessMerchant;

    @ApiModelProperty("状态：0=启用；1=禁用")
    @NotNull(message = "商户状态不能为空")
    private Integer status;

    @ApiModelProperty("联系电话")
    @NotBlank(message = "联系电话不能为空")
    private String phone;

    @ApiModelProperty("主体名称")
    @NotBlank(message = "主体名称不能为空")
    private String principalName;

    @ApiModelProperty("统一社会信息代码")
    @NotBlank(message = "统一社会信息代码不能为空")
    private String unifiedSocialInformationCode;

    @ApiModelProperty("收款账号")
    @NotBlank(message = "收款账号不能为空")
    private String accountNumber;

    @ApiModelProperty("开户行")
    @NotBlank(message = "开户行不能为空")
    private String openingBank;

    @ApiModelProperty("公共字段：创建人编码")
    private String createUserCode;

    @ApiModelProperty("创建人名称")
    private String createUserName;

    @ApiModelProperty("修改人编码")
    private String modifiedUserCode;

    @ApiModelProperty("修改人名称")
    private String modifiedUserName;
}
