/*
 * Decompiled with CFR 0.152.
 */
package com.bizvane.fitmentservice.models.vo.graphic.info;

import com.bizvane.fitmentservice.models.enums.GraphicSourceTypeEnums;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.format.annotation.DateTimeFormat;

public class AppletGraphicAddReq {
    @ApiModelProperty(value="\u6765\u6e90\u7c7b\u578b 1\u672c\u5730\u56fe\u6587 2\u7ebf\u4e0a\u56fe\u6587")
    @NotNull(message="\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer sourceType;
    @ApiModelProperty(value="\u6587\u7ae0\u5934\u56fe")
    @NotBlank(message="\u6587\u7ae0\u5934\u56fe\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6587\u7ae0\u5934\u56fe\u4e0d\u80fd\u4e3a\u7a7a") String graphicTopImgs;
    @ApiModelProperty(value="\u6587\u7ae0\u6807\u9898")
    @NotBlank(message="\u6587\u7ae0\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6587\u7ae0\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a") String graphicTopic;
    @ApiModelProperty(value="\u94fe\u63a5")
    private String graphicUrl;
    @ApiModelProperty(value="\u65e5\u671f")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @JsonFormat(pattern="yyyy-MM-dd", timezone="GMT+8")
    private Date graphicDate;
    @ApiModelProperty(value="\u6587\u7ae0\u5185\u5bb9")
    private String graphicContent;
    @ApiModelProperty(value="\u521d\u59cb\u9605\u8bfb\u603b\u6570 \u9ed8\u8ba4 0")
    private Integer initReadCount;
    @ApiModelProperty(value="\u6392\u5e8f\u5b57\u6bb5 0\u6700\u524d,\u6570\u5b57\u8d8a\u5927\u8d8a\u5728\u540e")
    private Integer sort;
    @ApiModelProperty(value="\u56fe\u6587\u6d3b\u52a8 id")
    @NotNull(message="\u56fe\u6587\u6d3b\u52a8 id\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u56fe\u6587\u6d3b\u52a8 id\u4e0d\u80fd\u4e3a\u7a7a") Long graphicActivityId;

    @AssertTrue(message="\u6765\u6e90\u7c7b\u578b\u4e0d\u6b63\u786e")
    private @AssertTrue(message="\u6765\u6e90\u7c7b\u578b\u4e0d\u6b63\u786e") boolean isGraphicSource() {
        return GraphicSourceTypeEnums.getByCode(this.sourceType) != null;
    }

    @AssertTrue(message="\u672c\u5730\u56fe\u6587,\u6587\u7ae0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a")
    private @AssertTrue(message="\u672c\u5730\u56fe\u6587,\u6587\u7ae0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a") boolean isLocalGraphic() {
        GraphicSourceTypeEnums typeEnums = GraphicSourceTypeEnums.getByCode(this.sourceType);
        if (typeEnums == GraphicSourceTypeEnums.LOCAL_GRAPHIC) {
            return StringUtils.isNotBlank((CharSequence)this.graphicContent);
        }
        return true;
    }

    @AssertTrue(message="\u7ebf\u4e0a\u56fe\u6587,\u94fe\u63a5\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a")
    private @AssertTrue(message="\u7ebf\u4e0a\u56fe\u6587,\u94fe\u63a5\uff0c\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a") boolean isOnlineGraphic() {
        GraphicSourceTypeEnums typeEnums = GraphicSourceTypeEnums.getByCode(this.sourceType);
        if (typeEnums == GraphicSourceTypeEnums.ONLINE_GRAPHIC) {
            return StringUtils.isNotBlank((CharSequence)this.graphicUrl) && this.graphicDate != null;
        }
        return true;
    }

    public Integer getSourceType() {
        return this.sourceType;
    }

    public String getGraphicTopImgs() {
        return this.graphicTopImgs;
    }

    public String getGraphicTopic() {
        return this.graphicTopic;
    }

    public String getGraphicUrl() {
        return this.graphicUrl;
    }

    public Date getGraphicDate() {
        return this.graphicDate;
    }

    public String getGraphicContent() {
        return this.graphicContent;
    }

    public Integer getInitReadCount() {
        return this.initReadCount;
    }

    public Integer getSort() {
        return this.sort;
    }

    public Long getGraphicActivityId() {
        return this.graphicActivityId;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    public void setGraphicTopImgs(String graphicTopImgs) {
        this.graphicTopImgs = graphicTopImgs;
    }

    public void setGraphicTopic(String graphicTopic) {
        this.graphicTopic = graphicTopic;
    }

    public void setGraphicUrl(String graphicUrl) {
        this.graphicUrl = graphicUrl;
    }

    public void setGraphicDate(Date graphicDate) {
        this.graphicDate = graphicDate;
    }

    public void setGraphicContent(String graphicContent) {
        this.graphicContent = graphicContent;
    }

    public void setInitReadCount(Integer initReadCount) {
        this.initReadCount = initReadCount;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public void setGraphicActivityId(Long graphicActivityId) {
        this.graphicActivityId = graphicActivityId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppletGraphicAddReq)) {
            return false;
        }
        AppletGraphicAddReq other = (AppletGraphicAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sourceType = this.getSourceType();
        Integer other$sourceType = other.getSourceType();
        if (this$sourceType == null ? other$sourceType != null : !((Object)this$sourceType).equals(other$sourceType)) {
            return false;
        }
        String this$graphicTopImgs = this.getGraphicTopImgs();
        String other$graphicTopImgs = other.getGraphicTopImgs();
        if (this$graphicTopImgs == null ? other$graphicTopImgs != null : !this$graphicTopImgs.equals(other$graphicTopImgs)) {
            return false;
        }
        String this$graphicTopic = this.getGraphicTopic();
        String other$graphicTopic = other.getGraphicTopic();
        if (this$graphicTopic == null ? other$graphicTopic != null : !this$graphicTopic.equals(other$graphicTopic)) {
            return false;
        }
        String this$graphicUrl = this.getGraphicUrl();
        String other$graphicUrl = other.getGraphicUrl();
        if (this$graphicUrl == null ? other$graphicUrl != null : !this$graphicUrl.equals(other$graphicUrl)) {
            return false;
        }
        Date this$graphicDate = this.getGraphicDate();
        Date other$graphicDate = other.getGraphicDate();
        if (this$graphicDate == null ? other$graphicDate != null : !((Object)this$graphicDate).equals(other$graphicDate)) {
            return false;
        }
        String this$graphicContent = this.getGraphicContent();
        String other$graphicContent = other.getGraphicContent();
        if (this$graphicContent == null ? other$graphicContent != null : !this$graphicContent.equals(other$graphicContent)) {
            return false;
        }
        Integer this$initReadCount = this.getInitReadCount();
        Integer other$initReadCount = other.getInitReadCount();
        if (this$initReadCount == null ? other$initReadCount != null : !((Object)this$initReadCount).equals(other$initReadCount)) {
            return false;
        }
        Integer this$sort = this.getSort();
        Integer other$sort = other.getSort();
        if (this$sort == null ? other$sort != null : !((Object)this$sort).equals(other$sort)) {
            return false;
        }
        Long this$graphicActivityId = this.getGraphicActivityId();
        Long other$graphicActivityId = other.getGraphicActivityId();
        return !(this$graphicActivityId == null ? other$graphicActivityId != null : !((Object)this$graphicActivityId).equals(other$graphicActivityId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppletGraphicAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sourceType = this.getSourceType();
        result = result * 59 + ($sourceType == null ? 43 : ((Object)$sourceType).hashCode());
        String $graphicTopImgs = this.getGraphicTopImgs();
        result = result * 59 + ($graphicTopImgs == null ? 43 : $graphicTopImgs.hashCode());
        String $graphicTopic = this.getGraphicTopic();
        result = result * 59 + ($graphicTopic == null ? 43 : $graphicTopic.hashCode());
        String $graphicUrl = this.getGraphicUrl();
        result = result * 59 + ($graphicUrl == null ? 43 : $graphicUrl.hashCode());
        Date $graphicDate = this.getGraphicDate();
        result = result * 59 + ($graphicDate == null ? 43 : ((Object)$graphicDate).hashCode());
        String $graphicContent = this.getGraphicContent();
        result = result * 59 + ($graphicContent == null ? 43 : $graphicContent.hashCode());
        Integer $initReadCount = this.getInitReadCount();
        result = result * 59 + ($initReadCount == null ? 43 : ((Object)$initReadCount).hashCode());
        Integer $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : ((Object)$sort).hashCode());
        Long $graphicActivityId = this.getGraphicActivityId();
        result = result * 59 + ($graphicActivityId == null ? 43 : ((Object)$graphicActivityId).hashCode());
        return result;
    }

    public String toString() {
        return "AppletGraphicAddReq(sourceType=" + this.getSourceType() + ", graphicTopImgs=" + this.getGraphicTopImgs() + ", graphicTopic=" + this.getGraphicTopic() + ", graphicUrl=" + this.getGraphicUrl() + ", graphicDate=" + this.getGraphicDate() + ", graphicContent=" + this.getGraphicContent() + ", initReadCount=" + this.getInitReadCount() + ", sort=" + this.getSort() + ", graphicActivityId=" + this.getGraphicActivityId() + ")";
    }
}

