package com.bizvane.fitmentservice.models.vo.graphic.info;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

@Data
public class AppletGraphicUpdateFieldReq {

    @ApiModelProperty(value = "图文id")
    @NotNull(message = "图文id不能为空")
    private Long graphicId;

    @ApiModelProperty(value = "排序")
    private Integer sort;

    @ApiModelProperty(value = "是否热门")
    private Boolean hot;

    @AssertTrue(message = "sort和hot不能同时为空")
    public boolean isAllNotNull(){
        return ObjectUtils.anyNotNull(sort,hot);
    }
}
