package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.vo.graphic.info.*;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import javax.validation.Valid;
import java.util.List;

@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}")
public interface AppletGraphicV2ServiceRpc {

    /**
     * 批量查询图文详情
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/graphicV2/batch", method = RequestMethod.POST)
    ResponseData<List<AppletGraphicBatchRsp>> batch(@RequestBody @Valid AppletGraphicBatchReq req);

    /**
     * 查询图文详情
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/graphicV2/selectById", method = RequestMethod.POST)
    ResponseData<AppletGraphicDetailRsp> selectById(@RequestBody @Valid AppletGraphicDetailReq req);

    /**
     * 查询图文列表(全部)
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/graphicV2/listAll", method = RequestMethod.POST)
    ResponseData<List<AppletGraphicDetailRsp>> listAll(@RequestBody @Valid AppletGraphicListReq req);


    /**
     * 8.图文上报，更新会员统计
     *
     * @param req
     * @return
     */
    @RequestMapping(value = "/graphicV2/updateMemberStatistic", method = RequestMethod.POST)
    ResponseData<AppletGraphicStatisticRsp> updateMemberStatistic(@RequestBody @Valid AppletGraphicStatisticReq req);
}
