package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.vo.AppletCustomerConfigVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @author zcc
 * @date 2022/6/17 11:28
 **/

@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}/customerConfigRpc")
public interface AppletCustomerConfigRpc {

    /**
     * 详情
     * @param sysCompanyId
     * @param sysBrandId
     * @return
     */
    @GetMapping("/getInfo")
    ResponseData<AppletCustomerConfigVo> getInfo(@RequestParam("sysCompanyId") Long sysCompanyId, @RequestParam("sysBrandId") Long sysBrandId);
}
