package com.bizvane.fitmentservice.interfaces;


import com.bizvane.fitmentservice.models.po.AppletGraphicPO;
import com.bizvane.fitmentservice.models.po.AppletGraphicPOExample;
import com.bizvane.fitmentservice.models.vo.graphic.info.*;
import com.bizvane.utils.responseinfo.PageInfo;
import com.bizvane.utils.responseinfo.ResponseData;
import com.bizvane.utils.tokens.SysAccountPO;

import java.util.List;

public interface AppletGraphicV2Service {

    /**
     * 新增图文
     * @param req
     * @return
     */
    ResponseData<AppletGraphicAddRsp> insert(AppletGraphicAddReq req, SysAccountPO sysAccountPo);

    /**
     * 修改图文
     * @param req
     * @return
     */
    ResponseData<AppletGraphicUpdateRsp> update(AppletGraphicUpdateReq req, SysAccountPO sysAccountPo);

    /**
     * 删除图文
     * @param req
     * @return
     */
    ResponseData<AppletGraphicDeleteRsp> delete(AppletGraphicDeleteReq req, SysAccountPO sysAccountPo);

    /**
     * 修改图文热门
     * @param req
     * @return
     */
    ResponseData<AppletGraphicUpdateFieldRsp> updateHot(AppletGraphicUpdateFieldReq req, SysAccountPO sysAccountPo);

    /**
     * 修改图文排序
     * @param req
     * @return
     */
    ResponseData<AppletGraphicUpdateFieldRsp> updateSort(AppletGraphicUpdateFieldReq req, SysAccountPO sysAccountPo);

    /**
     * 查询图文详情
     * @param req
     * @return
     */
    ResponseData<AppletGraphicDetailRsp> selectById(AppletGraphicDetailReq req);

    /**
     * 查询图文列表(分页)
     * @param req
     * @return
     */
    ResponseData<PageInfo<AppletGraphicDetailRsp>> page(AppletGraphicListReq req);

    /**
     * 查询图文列表(全部)
     * @param req
     * @return
     */
    ResponseData<List<AppletGraphicDetailRsp>> listAll(AppletGraphicListReq req);

    /**
     * 批量查询图文详情
     * @param req
     * @return
     */
    ResponseData<List<AppletGraphicBatchRsp>> batch(AppletGraphicBatchReq req);

    /**
     * 8.图文上报，更新会员统计
     * @param req
     * @return
     */
    ResponseData<AppletGraphicStatisticRsp> updateMemberStatistic(AppletGraphicStatisticReq req);
}
