package com.bizvane.fitmentservice.utils;

import com.bizvane.utils.responseinfo.PageInfo;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageUtils {

    public static <T,R> PageInfo<R> getList(PageInfo<T> resultPageInfo, Function<T,R> function){
        List<R> resultList = resultPageInfo.getList().stream().map(function).collect(Collectors.toList());
        PageInfo<R> rPageInfo = new PageInfo<>(resultList);
        rPageInfo.setTotal(resultPageInfo.getTotal());
        rPageInfo.setPages(resultPageInfo.getPages());
        rPageInfo.setPageNum(resultPageInfo.getPageNum());
        rPageInfo.setPageSize(resultPageInfo.getPageSize());
        return rPageInfo;
    }
}
