package com.bizvane.fitmentservice.models.vo.graphic.info;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class AppletGraphicUpdateReq extends AppletGraphicAddReq{

    @ApiModelProperty(value = "图文id")
    @NotNull(message = "图文id不能为空")
    private Long graphicId;

    @ApiModelProperty(value = "文章头图")
    @NotBlank(message = "文章头图不能为空")
    private String graphicTopImgs;

    @ApiModelProperty(value = "文章标题")
    @NotBlank(message = "文章标题不能为空")
    private String graphicTopic;

    @ApiModelProperty(value = "链接")
    private String graphicUrl;

    @ApiModelProperty(value = "日期")
    private Date graphicDate;

    @ApiModelProperty(value = "文章内容")
    private String graphicContent;

    @ApiModelProperty(value = "初始阅读总数 默认 0")
    private Integer initReadCount;

    @ApiModelProperty(value = "排序字段 0最前,数字越大越在后")
    private Integer sort;

}
