package com.bizvane.fitmentservice.models.enums;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum GraphicSourceTypeEnums {

    LOCAL_GRAPHIC(1, "本地图文"),
    ONLINE_GRAPHIC(2, "线上图文");

    private final int code;
    private final String description;

    public static GraphicSourceTypeEnums getByCode(int code) {
        for (GraphicSourceTypeEnums graphicSourceTypeEnums : GraphicSourceTypeEnums.values()) {
            if (graphicSourceTypeEnums.getCode() == code) {
                return graphicSourceTypeEnums;
            }
        }
        return null;
    }
}
