package com.bizvane.fitmentservice.models.Rpc;

import com.bizvane.fitmentservice.models.vo.AppletBrandFitmentReqVo;
import com.bizvane.fitmentservice.models.vo.AppletBrandFitmentVo;
import com.bizvane.utils.responseinfo.ResponseData;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.List;

/**
 * @author zcc
 * @date 2021/9/22 17:09
 **/
@FeignClient(value = "${feign.client.fitment.name}", path = "${feign.client.fitment.path}/brandFitmentRpc")
public interface AppletBrandFitmentRpc {

    /**
     * 获取小程序装修rpc接口
     * @param appletBrandFitmentReqVo
     * @return
     */
    @RequestMapping(value = "/getAppletFitmentByVo",method = RequestMethod.POST)
    public ResponseData<List<AppletBrandFitmentVo>> getAppletFitmentByVo(@RequestBody AppletBrandFitmentReqVo appletBrandFitmentReqVo);

}
